type = ['','info','success','warning','danger'];


um = {
    initPickColor: function(){
        $('.pick-class-label').click(function(){
            var new_class = $(this).attr('new-class');
            var old_class = $('#display-buttons').attr('data-class');
            var display_div = $('#display-buttons');
            if(display_div.length) {
            var display_buttons = display_div.find('.btn');
            display_buttons.removeClass(old_class);
            display_buttons.addClass(new_class);
            display_div.attr('data-class', new_class);
            }
        });
    },

    checkScrollForTransparentNavbar: debounce(function() {
            $navbar = $('.navbar[color-on-scroll]');
            scroll_distance = $navbar.attr('color-on-scroll') || 500;

            if($(document).scrollTop() > scroll_distance ) {
                if(transparent) {
                    transparent = false;
                    $('.navbar[color-on-scroll]').removeClass('navbar-transparent');
                    $('.navbar[color-on-scroll]').addClass('navbar-default');
                }
            } else {
                if( !transparent ) {
                    transparent = true;
                    $('.navbar[color-on-scroll]').addClass('navbar-transparent');
                    $('.navbar[color-on-scroll]').removeClass('navbar-default');
                }
            }
    }, 17),
    
    initChartGender: function(){
        
        $.post("getData/getGender.php",
        function(data){
            data = jQuery.parseJSON(data);

            console.log(data);

            var dataPreferences = {
              series: [
                [25, 30, 20, 25]
              ]
            };
            
            var optionsPreferences = {
              donut: true,
              donutWidth: 40,
              startAngle: 0,
              total: 100,
              showLabel: false,
              axisX: {
                showGrid: false
              }
            };
            
            Chartist.Pie('#chartGender', dataPreferences, optionsPreferences);
            
            Chartist.Pie('#chartGender', {
              labels: [data.totalmale + '%', data.totalfemale + '%'],
              series: [data.totalmale, data.totalfemale]
            });
    
        });

    },

    initChartState: function(){
        
      $.post("getData/getState.php",
      function(data){

          data = jQuery.parseJSON(data);
          console.log(data);

          var datachart = {
              labels: [
                ['Perak'],
                ['Selangor'],
                ['Melaka'],
                ['Kuala Lumpur'],
                ['Kelantan'],
                ['Johor'],
                ['Terengganu'],
                ['Perlis'],
                ['Negeri Sembilan'],
                ['Pulau Pinang'],
                ['Pahang'],
                ['Kedah'],
                ['Sabah'],
                ['Sarawak'],
                ['Others']
              ],
              series: [
                [data.Perak, data.Selangor, data.Melaka, data.KualaLumpur, data.Kelantan, data.Johor, data.Terengganu, data.Perlis,
                   data.NegeriSembilan, data.PulauPinang, data.Pahang, data.Kedah, data.Sabah, data.Sarawak, data.Others],
              ]
            };
  
          var options = {
              seriesBarDistance: 15,
              axisX: {
                  showGrid: false
              },
              height: "245px"
          };
  
          var responsiveOptions = [
            ['screen and (max-width: 640px)', {
              seriesBarDistance: 5,
              axisX: {
                labelInterpolationFnc: function (value) {
                  return value[0];
                }
              }
            }]
          ];
  
          Chartist.Bar('#chartState', datachart, options, responsiveOptions);
      });

  },

//Age Chart

initChartAge: function(){
        
  $.post("getData/getAge.php",
  function(data){

      data = jQuery.parseJSON(data);
      console.log(data);

      var datachart = {
          labels: [
            ['13-17'],
            ['18-25'],
            ['26-33'],
            ['34-40'],
            ['41-50'],
            ['>50']
          ],
          series: [
            [data.Age13_17, data.Age18_25, data.Age26_33, data.Age34_40, data.Age41_50, data.Age50],
          ]
        };

      var options = {
          seriesBarDistance: 15,
          axisX: {
              showGrid: false
          },
          height: "245px"
      };

      var responsiveOptions = [
        ['screen and (max-width: 640px)', {
          seriesBarDistance: 5,
          axisX: {
            labelInterpolationFnc: function (value) {
              return value[0];
            }
          }
        }]
      ];

      Chartist.Bar('#chartAge', datachart, options, responsiveOptions);
  });

},

	showNotification: function(from, align){
    	color = Math.floor((Math.random() * 4) + 1);

    	$.notify({
        	icon: "pe-7s-gift",
        	message: "Welcome to <b>Light Bootstrap Dashboard</b> - a beautiful freebie for every web developer."

        },{
            type: type[color],
            timer: 4000,
            placement: {
                from: from,
                align: align
            }
        });
	}


}
